function [yQ, totalBits] = performEncoding(y, Fs, bits, FFTLength, M, F, k, thres, totalBits)

% performs quantization on the result of the analysis filter bank
% also keeps track of the number of bits used

% find low and high frequencies for this filter in the bank
center = k*Fs /(2*M);
low = center - Fs/(2*M);
high = center + Fs/(2*M);

% find the index into the frequency array that corresponds to low and high
lowIndex = max(find(F<low));
if (isempty(lowIndex))
   lowIndex = 1;
end

highIndex = max(find(F<high));

% range of amplitude levels (in our case 65536)
R = 2^bits;

% find the number of bits needed to quantize with by finding the minimum of the 
% masking threshold over the frequency range of this filter

% auditory threshold of hearing
ATH=(3.64.*(F./1000).^(-.8) - 6.5.*exp(-0.6.*(F./1000-3.3).^2) + 0.001.*(F./1000).^4);

% bit assignment
b = min(ceil(log2(R./max(min(thres(lowIndex:highIndex)'),0))),16);

% perform uniform quantization
yQ = q(y, b);
yQ = iq(yQ, b)';    
  
% calculate how many bits we need for quantization  
newBits = log2(bits) + b * FFTLength/M;
   
% add the bit count to the total
totalBits = totalBits + newBits;




